@echo off
setlocal EnableDelayedExpansion

:: Marker for Creators Import - Windows Installer
:: Installiert die Premiere Pro Extension automatisch

title Marker for Creators Import Installer
color 0A
cls

echo ========================================
echo  Marker for Creators Import Installer
echo ========================================
echo.

:: Extension Ordner
set "EXT_DIR=%APPDATA%\Adobe\CEP\extensions\MarkerForCreators"

:: Erstelle Extension Ordner
echo [1/3] Erstelle Extension-Ordner...
if not exist "%EXT_DIR%" mkdir "%EXT_DIR%"
if not exist "%EXT_DIR%\CSXS" mkdir "%EXT_DIR%\CSXS"
if not exist "%EXT_DIR%\jsx" mkdir "%EXT_DIR%\jsx"
if not exist "%EXT_DIR%\lib" mkdir "%EXT_DIR%\lib"

:: Kopiere Dateien aus dem gleichen Verzeichnis wie die .bat/.exe
set "SOURCE_DIR=%~dp0"

echo [2/3] Kopiere Extension-Dateien...
xcopy /E /I /Y "%SOURCE_DIR%CSXS" "%EXT_DIR%\CSXS" >nul
xcopy /E /I /Y "%SOURCE_DIR%jsx" "%EXT_DIR%\jsx" >nul
xcopy /E /I /Y "%SOURCE_DIR%lib" "%EXT_DIR%\lib" >nul
copy /Y "%SOURCE_DIR%index.html" "%EXT_DIR%\" >nul
copy /Y "%SOURCE_DIR%.debug" "%EXT_DIR%\" >nul 2>nul

:: Aktiviere Debug-Modus via Registry
echo [3/3] Aktiviere Debug-Modus...
reg add "HKEY_CURRENT_USER\Software\Adobe\CSXS.10" /v PlayerDebugMode /t REG_SZ /d 1 /f >nul 2>&1
reg add "HKEY_CURRENT_USER\Software\Adobe\CSXS.11" /v PlayerDebugMode /t REG_SZ /d 1 /f >nul 2>&1

echo.
echo ========================================
echo  ✓ Installation erfolgreich!
echo ========================================
echo.
echo Extension installiert in:
echo %EXT_DIR%
echo.
echo Naechste Schritte:
echo   1. Starte Premiere Pro neu
echo   2. Gehe zu: Window ^> Extensions ^> Marker for Creators Import
echo.
echo ========================================
echo.

pause
exit /b 0
